# Securing Management Access to Cisco Devices

## Overview

- Securing management access is vital for overall network security.
- Multiple features help control management access:
    - Interface and service-specific ACLs
    - Control Plane Protection (CPPr)
    - Management Plane Protection (MPP)

---

## Access Control Features

### 1. Interface and Service-Specific ACLs

- **Benefits:**
    - Simple implementation
    - Can limit access to specific services (interface ACLs: any service; service ACLs: specific services)
- **Limitations:**
    - Interface ACLs: Hard to scale with many interfaces
    - Service ACLs: May not cover all protocols/services

### 2. Control Plane Protection (CPPr)

- **Benefits:**
    - Centralized, easy to configure
    - Can control access to any local management service
- **Limitations:**
    - Not supported on all Cisco platforms

### 3. Management Plane Protection (MPP)

- **Benefits:**
    - Straightforward setup
    - Supports out-of-band (OOB) management networks for enhanced security
- **Limitations:**
    - Requires dedicated OOB management interface
    - Not usable for in-band management

---

## Recommended Security Practices

### Use Secure Protocols

- Use SSH and HTTPS instead of Telnet and HTTP for management access:
    - Provides data integrity, authentication, and privacy
- Use SNMPv3 instead of SNMPv1/v2 for secure network management

### Defense in Depth

- Combine multiple access control features for layered protection
- Compensates for possible vulnerabilities or misconfigurations

---

## Access Control Features: Benefits & Limitations Table

|Feature|Benefit|Limitation|
|---|---|---|
|Interface ACLs|Limit access to any service|Not scalable with many interfaces|
|Service-specific ACLs|Easy to configure/manage|Can't limit access to all services|
|CPPr|Centralized, flexible|Not on all platforms|
|MPP|Easy, supports OOB access|Requires OOB management network|

---

## Use Case: Securing Access to a Cisco Router

### Recommended Steps

- Enable secure protocols (SSHv2, HTTPS, SNMPv3)
- Enable local authentication
- Apply service-specific ACLs to restrict management sources
- Optionally implement CPPr and/or MPP as required by network design

### Example Implementation

- Only allow SSHv2, HTTPS, and SNMP from trusted subnet (e.g., 10.10.10.0/24)
- Enable local authentication for management protocols
- Apply CPPr for centralized control
- Enable MPP on dedicated interface for OOB management

---

## Configuration Examples

### SSHv2 Access

- Configure hostname and domain name
- Generate RSA key pair
- Create local user accounts
- Enable SSHv2 and local authentication on vty lines
- Restrict vty lines to SSH only (`transport input ssh`)

### HTTPS Access

- Disable HTTP server; enable HTTPS server
- Generates a self-signed certificate (consider using CA-signed certificates for production)
- Authenticate HTTPS sessions against local user database

---

## Filtering Management Access with ACLs

- Use standard IP ACLs to limit source IPs for management access
- Apply ACLs to:
    - vty lines (SSH)
    - HTTP/HTTPS server (`ip http access-class`)
    - SNMP groups/users

---

## Configuring CPPr and MPP

### CPPr (Control Plane Protection)

- Use extended ACLs to permit trusted management traffic (SSH, HTTPS, SNMP)
- Class maps reference the ACLs
- Policy maps define allowed rates and drop excess traffic
- Service policies apply policy map to the control-plane

### MPP (Management Plane Protection)

- Designate a physical interface as management-only (OOB)
- Allow only specified protocols (SSH, HTTPS, SNMP)

---

## Disabling Unused Management Services

- Preserves resources and reduces attack surface
- Disable unneeded protocols:
    - **Telnet:** Use SSH instead
    - **HTTP:** Use HTTPS instead
    - **CDP:** Disable on external/data-only interfaces
    - **DNS:** Disable if not needed (`no ip domain-lookup`)
    - **SNMP:** Use only SNMPv3; disable if not required

---

## Key Takeaways

- Secure management access using layered controls (ACLs, CPPr, MPP)
- Prefer secure protocols (SSHv2, HTTPS, SNMPv3)
- Always disable unnecessary services for better security
- Use access control features in combination for defense in depth

---

## Notes

- Security configurations should be tailored to network requirements and device capabilities.
- Always verify access after configuration changes to ensure only authorized users can manage devices.
- Regularly review and update access control settings to address new threats or network changes.